<?php 
class Cmsc2fab0fe4a3969082985f98bf25c6965b1df790e4cbf4e8c0eaf7b3a48d56447Class extends Cms\Classes\PartialCode
{
// How to activate this form:
//
// - 1. Open Admin Panel → Settings → Team → Manage Groups
// - 2. Create a New Group → Set Code field to "contact-team"
// - 3. Select Users tab → Click Add Users
// - 4. Click Save
//
public function onSubmitContactForm()
{
    // Validate the form
    // @see https://docs.octobercms.com/3.x/cms/features/validation.html
    //
    // - Argument 1 is the attributes and their rules
    // - Argument 2 is custom error messages for each attribute rule (translated)
    // - Argument 3 is custom names for each attribute (translated)
    //
    $data = Request::validate([
        'first_name' => 'required|min:2|max:64',
        'email' => 'required|email|min:2|max:64',
        'comments' => 'required|min:5',
    ], [
        'comments' => ['required' => __("Please actually write something to us...")]
    ], [
        'first_name' => __("name"),
    ]);

    // Notify the 'contact-team' group with 'backend:contact-form' mail template
    //
    $group = \Backend\Models\UserGroup::where('code', 'contact-team')->first();
    if (!$group) {
        throw new ApplicationException(__("Sorry, this contact form is not enabled: We cannot receive emails at the moment, please try using another method."));
    }

    Mail::sendTo(
        $group->users->pluck('full_name', 'email')->all(),
        'backend:contact-form',
        $data
    );

    $this['isSubmit'] = true;
    $this['emailAddress'] = post('email');
}
}
