<?php namespace Tailor\ContentFields;

use October\Contracts\Element\ListElement;
use October\Contracts\Element\FilterElement;

/**
 * DatePickerField
 *
 * @package october\tailor
 * @author Alexey Bobkov, Samuel Georges
 */
class DatePickerField extends FallbackField
{
    /**
     * defineListColumn
     */
    public function defineListColumn(ListElement $list, $context = null)
    {
        $list->defineColumn($this->fieldName, $this->label)
            ->displayAs($this->mode ?: 'datetime')
            ->shortLabel($this->shortLabel)
            ->useConfig($this->column ?: [])
        ;
    }

    /**
     * defineFilterScope
     */
    public function defineFilterScope(FilterElement $filter, $context = null)
    {
        $filter->defineScope($this->fieldName, $this->label)
            ->displayAs('date')
            ->shortLabel($this->shortLabel)
            ->useConfig($this->scope ?: [])
        ;
    }

    /**
     * extendModelObject will extend the record model.
     */
    public function extendModelObject($model)
    {
        $model->addDateAttribute($this->fieldName);
    }

    /**
     * extendDatabaseTable adds any required columns to the database.
     */
    public function extendDatabaseTable($table)
    {
        $table->datetime($this->fieldName)->nullable();
    }
}
