<?php return [
  'cms_object' => [
    'invalid_file' => 'Invalid file name: :name. File names can contain only alphanumeric symbols, underscores, dashes and dots. Some examples of correct file names: page.htm, page, subdirectory/page',
    'invalid_file_inspector' => 'Invalid file name. File names can contain only alphanumeric symbols, underscores, dashes and dots. Some examples of correct file names: page.htm, page, subdirectory/page',
    'invalid_property' => 'The property \':name\' cannot be set',
    'file_already_exists' => 'File \':name\' already exists.',
    'error_saving' => 'Error saving file \':name\'. Please check write permissions.',
    'error_creating_directory' => 'Error creating directory :name. Please check write permissions.',
    'invalid_file_extension' => 'Invalid file extension: :invalid. Allowed extensions are: :allowed.',
    'error_deleting' => 'Error deleting the template file \':name\'. Please check write permissions.',
    'delete_success' => 'Templates deleted: :count.',
    'file_name_required' => 'The File Name field is required.',
    'safe_mode_enabled' => 'Safe mode is currently enabled that prevents PHP code changes.',
  ],
  'dashboard' => [
    'active_theme' => [
      'widget_title_default' => 'Website',
      'online' => 'Online',
      'maintenance' => 'In Maintenance',
      'manage_themes' => 'Manage Themes',
      'customize_theme' => 'Customize Theme',
    ],
  ],
  'theme' => [
    'active' => [
      'not_set' => 'The active theme is not set.',
      'not_found' => 'The active theme is not found.',
      'is_locked' => 'The theme \':theme\' is locked and cannot be used. Please duplicate this theme or create a child theme.',
    ],
    'edit' => [
      'not_set' => 'The edit theme is not set.',
      'not_found' => 'The edit theme is not found.',
      'not_match' => 'The object you\'re trying to access doesn\'t belong to the theme being edited. Please reload the page.',
    ],
    'setting_edit_theme' => 'Changing edit theme',
    'edit_theme_changed' => 'Edit theme changed',
  ],
  'page' => [
    'not_found_name' => 'The page \':name\' is not found',
    'not_found' => [
      'label' => 'Page Not Found',
      'help' => 'The requested page cannot be found.',
    ],
    'custom_error' => [
      'label' => 'Page Error',
      'help' => 'We\'re sorry, but something went wrong and the page cannot be displayed.',
    ],
    'menu_label' => 'Pages',
    'unsaved_label' => 'Unsaved page(s)',
    'no_list_records' => 'No pages found',
    'new' => 'New page',
    'invalid_url' => 'Invalid URL format. The URL should start with the forward slash symbol and can contain digits, Latin letters and the following symbols: ._-[]:?|/+*^$',
    'delete_confirm_multiple' => 'Delete selected pages?',
    'delete_confirm_single' => 'Delete this page?',
    'no_layout' => '-- no layout --',
    'title' => 'Page title',
    'url' => 'Page URL',
    'url_required' => 'The page URL is required.',
    'file_name' => 'Page file name',
    'editor_node_name' => 'Pages',
    'editor_sorting' => 'Sort Pages',
    'editor_sort_by_url' => 'URL',
    'editor_sort_by_title' => 'Title',
    'editor_sort_by_file_name' => 'File Name',
    'editor_grouping' => 'Group Pages',
    'editor_group_by_filepath' => 'File Path',
    'editor_group_by_url' => 'URL',
    'editor_display' => 'Display',
    'editor_display_title' => 'Title',
    'editor_display_url' => 'URL',
    'editor_display_file' => 'File Path',
    'editor_markup' => 'Markup',
    'editor_code' => 'Code',
    'description_hint' => 'The description is optional and only visible in the back-end user interface.',
    'create_new' => 'New Page',
  ],
  'layout' => [
    'not_found_name' => 'The layout \':name\' is not found',
    'menu_label' => 'Layouts',
    'unsaved_label' => 'Unsaved layout(s)',
    'no_list_records' => 'No layouts found',
    'new' => 'New layout',
    'delete_confirm_multiple' => 'Delete selected layouts?',
    'delete_confirm_single' => 'Delete this layout?',
    'editor_node_name' => 'Layouts',
    'create_new' => 'New Layout',
  ],
  'partial' => [
    'not_found_name' => 'The partial \':name\' is not found.',
    'invalid_name' => 'Invalid partial name: :name.',
    'menu_label' => 'Partials',
    'unsaved_label' => 'Unsaved partial(s)',
    'no_list_records' => 'No partials found',
    'delete_confirm_multiple' => 'Delete selected partials?',
    'delete_confirm_single' => 'Delete this partial?',
    'editor_node_name' => 'Partials',
    'new' => 'New partial',
    'create_new' => 'New Partial',
  ],
  'content' => [
    'not_found_name' => 'The content file \':name\' is not found.',
    'menu_label' => 'Content',
    'unsaved_label' => 'Unsaved content',
    'no_list_records' => 'No content files found',
    'delete_confirm_multiple' => 'Delete selected content files or directories?',
    'delete_confirm_single' => 'Delete this content file?',
    'editor_node_name' => 'Content Files',
    'new' => 'New Content File',
    'editor_content' => 'Content',
  ],
  'ajax_handler' => [
    'invalid_name' => 'Invalid AJAX handler name: :name.',
    'not_found' => 'AJAX handler \':name\' was not found.',
  ],
  'cms' => [
    'menu_label' => 'CMS',
  ],
  'sidebar' => [
    'add' => 'Add',
    'search' => 'Search...',
  ],
  'editor' => [
    'settings' => 'Settings',
    'title' => 'Title',
    'new_title' => 'New Page Title',
    'url' => 'URL',
    'filename' => 'File Name',
    'layout' => 'CMS Layout',
    'description' => 'Description',
    'preview' => 'Preview',
    'page' => 'CMS Page',
    'edit_theme' => 'Edit Theme',
    'change_edit_theme' => 'Change Edit Theme',
    'edit_theme_saved_changed_tabs' => 'You have unsaved changes in open tabs. Please save them or close the tabs in order to proceed.',
    'partial' => 'CMS Partial',
    'meta' => 'Meta',
    'meta_title' => 'Meta Title',
    'meta_description' => 'Meta Description',
    'markup' => 'Markup',
    'code' => 'Code',
    'content' => 'CMS Content File',
    'asset' => 'Asset File',
    'hidden' => 'Hidden',
    'hidden_comment' => 'Hidden pages are accessible only by logged-in back-end users.',
    'priority' => 'Priority',
    'priority_comment' => 'Priority layouts will load their contents before the page contents.',
    'enter_fullscreen' => 'Enter fullscreen mode',
    'exit_fullscreen' => 'Exit fullscreen mode',
    'open_searchbox' => 'Open Search box',
    'open_replacebox' => 'Open Replace box',
    'commit' => 'Commit',
    'reset' => 'Reset',
    'commit_confirm' => 'Are you sure you want to commit your changes to this file to the filesystem? This will overwrite the existing file on the filesystem',
    'reset_confirm' => 'Are you sure you want to reset this file to the copy that is on the filesystem? This will completely replace it with the file that is on the filesystem',
    'committing' => 'Committing',
    'resetting' => 'Resetting',
    'commit_success' => 'The :type has been committed to the filesystem',
    'reset_success' => 'The :type has been reset to the filesystem version',
    'error_loading_header' => 'Error loading template',
    'component_list' => 'Components',
    'component_list_description' => 'To add a component, click it or drag and drop to the Markup editor.',
    'info' => 'Info',
    'refresh' => 'Refresh',
    'create' => 'Create',
    'manage_themes' => 'Manage Themes',
    'error_no_doctype_permissions' => 'You don\'t have permission to manage the document type: :doctype',
  ],
  'asset' => [
    'menu_label' => 'Assets',
    'unsaved_label' => 'Unsaved asset(s)',
    'drop_down_add_title' => 'Add...',
    'drop_down_operation_title' => 'Action...',
    'upload_files' => 'Upload File(s)',
    'create_file' => 'Create File',
    'create_directory' => 'New Directory',
    'directory_popup_title' => 'New Directory',
    'directory_name' => 'Directory Name',
    'directory_name_required' => 'The directory name is required',
    'rename_name_required' => 'The name is required',
    'rename' => 'Rename',
    'delete' => 'Delete',
    'move' => 'Move',
    'moving' => 'Moving selected items',
    'moved' => 'Successfully moved',
    'saved' => 'File saved',
    'deleted' => 'File deleted',
    'select' => 'Select',
    'new' => 'New File',
    'rename_popup_title' => 'Rename',
    'rename_new_name' => 'New name',
    'invalid_path' => 'Path can contain only digits, Latin letters, spaces and the following symbols: ._-@/',
    'error_deleting_file' => 'Error deleting file :name.',
    'error_deleting_dir_not_empty' => 'Error deleting directory :name. The directory is not empty.',
    'error_deleting_dir' => 'Error deleting directory :name.',
    'invalid_name' => 'Name can contain only digits, Latin letters, spaces and the following symbols: ._-@',
    'original_not_found' => 'Original file or directory not found',
    'already_exists' => 'File or directory with this name already exists',
    'error_renaming' => 'Error renaming the file or directory',
    'name_cant_be_empty' => 'The name cannot be empty',
    'type_not_allowed' => 'Only the following file types are allowed: :allowed_types',
    'error_uploading_file' => 'Error uploading file \':name\': :error',
    'move_please_select' => 'please select',
    'move_destination' => 'Destination Directory',
    'move_popup_title' => 'Move Assets',
    'move_button' => 'Move',
    'no_list_records' => 'No files found',
    'path' => 'Path',
    'editor_node_name' => 'Assets',
    'open' => 'Open',
  ],
  'component' => [
    'menu_label' => 'Components',
    'invalid_request' => 'The template cannot be saved because of invalid component data.',
    'no_records' => 'No components found',
    'not_found' => 'The component \':name\' is not found.',
    'method_not_found' => 'The component \':name\' does not contain a method \':method\'.',
    'expand_or_collapse' => 'Expand or collapse the component list',
    'remove' => 'Remove component',
    'expand_partial' => 'Expand Component Partial',
  ],
  'template' => [
    'invalid_type' => 'Unknown template type.',
    'not_found' => 'Template not found.',
    'saved' => 'Template saved',
    'saved_to_db' => 'Template saved to the database',
    'file_updated' => 'Template file updated',
    'reset_from_template_success' => 'Template was reset from file',
    'reloaded' => 'Template reloaded',
    'deleted' => 'Template deleted',
    'no_list_records' => 'No records found',
    'delete_confirm' => 'Delete selected templates?',
    'order_by' => 'Order By',
    'last_modified' => 'Last Modified',
    'storage' => 'Storage',
    'template_file' => 'Template File',
    'storage_filesystem' => 'Filesystem',
    'storage_database' => 'database',
    'update_file' => 'Update template file',
    'reset_from_file' => 'Reset from template file',
  ],
  'permissions' => [
    'name' => 'CMS',
    'manage_content' => 'Manage website content files',
    'manage_assets' => 'Manage website assets - images, JavaScript files, CSS files',
    'manage_pages' => 'Create, modify and delete website pages',
    'manage_layouts' => 'Create, modify and delete CMS layouts',
    'manage_partials' => 'Create, modify and delete CMS partials',
    'manage_themes' => 'Activate, deactivate and configure CMS themes',
    'manage_theme_options' => 'Configure customization options for the active theme',
  ],
  'theme_log' => [
    'hint' => 'This log displays any changes made to the theme by administrators in the back-end area.',
    'menu_label' => 'Theme Log',
    'menu_description' => 'View changes made to the active theme.',
    'empty_link' => 'Empty theme log',
    'empty_loading' => 'Emptying theme log...',
    'empty_success' => 'Theme log emptied',
    'return_link' => 'Return to theme log',
    'id' => 'ID',
    'id_label' => 'Log ID',
    'created_at' => 'Date & Time',
    'user' => 'User',
    'type' => 'Type',
    'type_create' => 'Create',
    'type_update' => 'Update',
    'type_delete' => 'Delete',
    'theme_name' => 'Theme',
    'theme_code' => 'Theme code',
    'old_template' => 'Template (Old)',
    'new_template' => 'Template (New)',
    'template' => 'Template',
    'diff' => 'Changes',
    'old_value' => 'Old Value',
    'new_value' => 'New Value',
    'preview_title' => 'Template Changes',
    'template_updated' => 'Template was updated',
    'template_created' => 'Template was created',
    'template_deleted' => 'Template was deleted',
  ],
  'intellisense' => [
    'learn_more' => 'Learn more',
    'docs' => [
      'partial' => 'Renders the contents of a CMS partial.',
      'ajaxpartial' => 'Renders the contents of a CMS partial with AJAX support.',
      'page' => 'Renders the contents of a CMS page into a layout template.',
      'content' => 'Renders a CMS content block.',
      'component' => 'Renders the default markup content for a CMS component.',
      'placeholder' => 'Renders a placeholder section.',
      'scripts' => 'Inserts JavaScript file references to scripts injected by the application.',
      'styles' => 'Renders CSS links to stylesheet files injected by the application.',
      'meta' => 'Renders HTML meta tags injected by the application.',
      'flash' => 'Renders any flash messages stored in the user session.',
      'verbatim' => 'Marks entire sections as being raw text that should not be parsed.',
      'macro' => 'Allows to define custom functions in a template.',
      'for' => 'Loop over each value in a collection.',
      'if' => 'Allows for conditional displaying of the template markup.',
      'abs_filter' => 'The `abs` filter returns the absolute value.',
      'batch_filter' => 'The `batch` filter "batches" items by returning a list of lists with the given number of items. A second parameter can be provided and used to fill in missing items.',
      'capitalize_filter' => 'The `capitalize` filter capitalizes a value. The first character will be uppercase, all others lowercase.',
      'column_filter' => 'The `column` filter returns the values from a single column in the input array.',
      'convert_encoding_filter' => 'The `convert_encoding` filter converts a string from one encoding to another. The first argument is the expected output charset and the second one is the input charset.',
      'country_name_filter' => 'The `country_name` filter returns the country name given its ISO-3166 two-letter code.',
      'currency_name_filter' => 'The `currency_name` filter returns the currency name given its three-letter code.',
      'currency_symbol_filter' => 'The `currency_symbol` filter returns the currency symbol given its three-letter code.',
      'data_uri_filter' => 'The `data_uri` filter generates a URL using the data scheme as defined in RFC 2397.',
      'date_filter' => 'The `date` filter formats a date to a given format.',
      'date_modify_filter' => 'The `date_modify` filter modifies a date with a given modifier string.',
      'default_filter' => 'The `default` filter returns the passed default value if the value is undefined or empty, otherwise the value of the variable.',
      'escape_filter' => 'The `escape` filter escapes a string using strategies that depend on the context.',
      'filter_filter' => 'The `filter` filter filters elements of a sequence or a mapping using an arrow function. The arrow function receives the value of the sequence or mapping.',
      'first_filter' => 'The `first` filter returns the first "element" of a sequence, a mapping, or a string.',
      'format_filter' => 'The `format` filter formats a given string by replacing the placeholders (placeholders follows the [sprintf](https://www.php.net/sprintf) notation).',
      'format_currency_filter' => 'The `format_currency` filter formats a number as a currency.',
      'join_filter' => 'The `join` filter returns a string which is the concatenation of the items of a sequence',
      'json_encode_filter' => 'The `json_encode` filter returns the JSON representation of a value.',
      'keys_filter' => 'The `keys` filter returns the keys of an array. It is useful when you want to iterate over the keys of an array.',
      'last_filter' => 'The `last` filter returns the last "element" of a sequence, a mapping, or a string.',
      'length_filter' => 'The `length` filter returns the number of items of a sequence or mapping, or the length of a string.',
      'lower_filter' => 'The `lower` filter converts a value to lowercase.',
      'map_filter' => 'The `map` filter applies an arrow function to the elements of a sequence or a mapping. The arrow function receives the value of the sequence or mapping.',
      'merge_filter' => 'The `merge` filter merges an array with another array.',
      'nl2br_filter' => 'The `nl2br` filter inserts HTML line breaks before all newlines in a string.',
      'number_format_filter' => 'The `number_format` filter formats numbers. It is a wrapper around PHP’s [number_format](https://www.php.net/number_format) function.',
      'reduce_filter' => 'The `reduce` filter iteratively reduces a sequence or a mapping to a single value using an arrow function, so as to reduce it to a single value. The arrow function receives the return value of the previous iteration and the current value of the sequence or mapping.',
      'replace_filter' => 'The `replace` filter formats a given string by replacing the placeholders.',
      'reverse_filter' => 'The `reverse` filter reverses a sequence, a mapping, or a string.',
      'round_filter' => 'The `round` filter rounds a number to a given precision.',
      'slice_filter' => 'The `slice` filter extracts a slice of a sequence, a mapping, or a string.',
      'sort_filter' => 'The `sort` filter sorts an array.',
      'spaceless_filter' => 'Use the `spaceless` filter to remove whitespace between HTML tags, not whitespace within HTML tags or whitespace in plain text.',
      'split_filter' => 'The `split` filter splits a string by the given delimiter and returns a list of strings.',
      'striptags_filter' => 'The `striptags` filter strips SGML/XML tags and replace adjacent whitespace by one space.',
      'title_filter' => 'The `title` filter returns a titlecased version of the value. Words will start with uppercase letters, all remaining characters are lowercase.',
      'trim_filter' => 'The `trim` filter strips whitespace (or other characters) from the beginning and end of a string.',
      'upper_filter' => 'The `upper` filter converts a value to uppercase.',
      'url_encode_filter' => 'The `url_encode` filter percent encodes a given string as URL segment or an array as query string.',
      'page_filter' => 'The `page` filter creates a link to a page using a page file name, without an extension, as a parameter.',
      'theme_filter' => 'The `theme` filter returns an address relative to the active theme path of the website. ',
      'app_filter' => 'The `app` filter returns an address relative to the public path of the website.',
      'media_filter' => 'The `media` filter returns an address relative to the public path of the [media manager library](https://docs.octobercms.com/4.x/cms/media/introduction.html).',
      'md_filter' => 'The `md` filter converts the value from Markdown to HTML format.',
      'raw_filter' => 'The `raw` filter marks the value as being "safe", which means that a variable will not be escaped if `raw` is the last filter applied to it.',
      'content_filter' => 'The `content` filter converts links and snippets found within the string as content.',
      'link_filter' => 'The `link` filter converts a link found in the supplied string.',
    ],
  ],
];
